implementation module stringconv

import StdList, StdOverloaded, StdString
import StdIOCommon

instance toString (a,b,c) | toString a & toString b & toString c where
	toString (a,b,c) = brackify (itemsList "," [toString a,toString b,toString c])
instance toString Modifiers where
	toString {shiftDown,optionDown,commandDown,controlDown,altDown}
		= curlify (itemsList "," (flatten [	if shiftDown   ["shiftDown"]   []
										  ,	if optionDown  ["optionDown"]  []
										  ,	if commandDown ["commandDown"] []
										  ,	if controlDown ["controlDown"] []
										  ,	if altDown     ["altDown"]     []
										  ]))
instance toString KeyboardState where
	toString (CharKey char keystate)				= brackify ("CharKey "+++fromChar char+++" "+++toString keystate)
	toString (SpecialKey special keystate modifiers)= brackify ("SpecialKey "+++toString (special,keystate,modifiers))
instance toString KeyState where
	toString (KeyDown isRepeat)	= brackify ("KeyDown "+++toString isRepeat)
	toString KeyUp				= "KeyUp"

curlify  x = "{"+++x+++"}"
brackify x = "("+++x+++")"

itemsList :: !String ![String] -> String
itemsList separator [x:xs]
	= x+++itemsList` xs
where
	itemsList` [x:xs]	= separator+++x+++itemsList` xs
	itemsList` _		= ""
itemsList _ _
	= ""
